<?php
/**
 * WPG Admin Settings View
 *
 * @package aos-wp-governance
 * @since   1.0.0
 */

defined('ABSPATH') || exit;

$deny_first = (bool)get_option('wpg_deny_first', true);
$alert_settings = get_option('wpg_alert_settings', []);
?>

<div class="wrap wpg-wrap">
    <h1 class="wpg-title">
        <span class="dashicons dashicons-shield"></span>
        <?php esc_html_e('Governance Settings', 'aos-wp-governance'); ?>
    </h1>

    <form id="wpg-settings-form" class="wpg-settings-form">
        <!-- Enforcement Mode -->
        <div class="wpg-card">
            <h2 class="wpg-card-title"><?php esc_html_e('Enforcement Mode', 'aos-wp-governance'); ?></h2>

            <div class="wpg-form-group">
                <label>
                    <input type="checkbox" name="deny_first" <?php checked($deny_first); ?>>
                    <?php esc_html_e('Deny-First Mode', 'aos-wp-governance'); ?>
                </label>
                <p class="wpg-help">
                    <?php esc_html_e('When enabled, evaluation stops on the first deny match (fail-fast). When disabled, all policies are evaluated and the most restrictive decision wins.', 'aos-wp-governance'); ?>
                </p>
            </div>
        </div>

        <!-- Alert Settings -->
        <div class="wpg-card">
            <h2 class="wpg-card-title"><?php esc_html_e('Deny Alerts', 'aos-wp-governance'); ?></h2>

            <div class="wpg-form-group">
                <label>
                    <input type="checkbox" name="email_enabled"
                        <?php checked(!empty($alert_settings['email_enabled'])); ?>>
                    <?php esc_html_e('Send email alert on deny', 'aos-wp-governance'); ?>
                </label>
            </div>

            <div class="wpg-form-group">
                <label for="wpg-alert-email"><?php esc_html_e('Alert Email Address', 'aos-wp-governance'); ?></label>
                <input type="email" id="wpg-alert-email" name="email_to"
                    value="<?php echo esc_attr($alert_settings['email_to'] ?? get_option('admin_email')); ?>"
                    placeholder="<?php echo esc_attr(get_option('admin_email')); ?>">
            </div>

            <div class="wpg-form-group">
                <label>
                    <input type="checkbox" name="webhook_enabled"
                        <?php checked(!empty($alert_settings['webhook_enabled'])); ?>>
                    <?php esc_html_e('Send webhook alert on deny', 'aos-wp-governance'); ?>
                </label>
            </div>

            <div class="wpg-form-group">
                <label for="wpg-webhook-url"><?php esc_html_e('Webhook URL', 'aos-wp-governance'); ?></label>
                <input type="url" id="wpg-webhook-url" name="webhook_url"
                    value="<?php echo esc_attr($alert_settings['webhook_url'] ?? ''); ?>"
                    placeholder="https://hooks.slack.com/services/...">
                <p class="wpg-help">
                    <?php esc_html_e('Receives a POST with JSON payload when an action is denied. Works with Slack, Discord, Zapier, etc.', 'aos-wp-governance'); ?>
                </p>
            </div>
        </div>

        <!-- System Info -->
        <div class="wpg-card">
            <h2 class="wpg-card-title"><?php esc_html_e('System Information', 'aos-wp-governance'); ?></h2>
            <table class="wpg-table wpg-table-info">
                <tbody>
                    <tr>
                        <td><strong><?php esc_html_e('Plugin Version', 'aos-wp-governance'); ?></strong></td>
                        <td><code><?php echo esc_html(WPG_VERSION); ?></code></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('DB Version', 'aos-wp-governance'); ?></strong></td>
                        <td><code><?php echo esc_html(get_option('wpg_db_version', '?')); ?></code></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('PHP Version', 'aos-wp-governance'); ?></strong></td>
                        <td><code><?php echo esc_html(PHP_VERSION); ?></code></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('WordPress Version', 'aos-wp-governance'); ?></strong></td>
                        <td><code><?php echo esc_html(get_bloginfo('version')); ?></code></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('MCP Adapter', 'aos-wp-governance'); ?></strong></td>
                        <td>
                            <?php if (defined('WP_MCP_VERSION')): ?>
                                <code><?php echo esc_html(WP_MCP_VERSION); ?></code>
                                <span class="wpg-badge wpg-badge-active"><?php esc_html_e('Active', 'aos-wp-governance'); ?></span>
                            <?php
else: ?>
                                <span class="wpg-badge wpg-badge-warning"><?php esc_html_e('Not Detected', 'aos-wp-governance'); ?></span>
                                <br><small class="wpg-text-muted">
                                    <?php esc_html_e('AOS WP Governance works with or without the MCP Adapter. It also intercepts direct ability calls.', 'aos-wp-governance'); ?>
                                </small>
                            <?php
endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Gate Status', 'aos-wp-governance'); ?></strong></td>
                        <td>
                            <?php if (get_transient('wpg_governance_paused')): ?>
                                <span class="wpg-badge wpg-badge-warning"><?php esc_html_e('PAUSED', 'aos-wp-governance'); ?></span>
                            <?php
else: ?>
                                <span class="wpg-badge wpg-badge-active"><?php esc_html_e('ACTIVE', 'aos-wp-governance'); ?></span>
                            <?php
endif; ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="wpg-form-actions">
            <button type="submit" class="button button-primary button-large">
                <?php esc_html_e('Save Settings', 'aos-wp-governance'); ?>
            </button>
        </div>
    </form>
</div>
